const CACHE_NAME = 'boonpos-shell-v1';
const SHELL_ASSETS = [
  '/',
  '/css/app.css',
  '/js/app.js',
  '/js/purchase.js',
  '/js/payment.js'
];

self.addEventListener('install', (event) => {
  event.waitUntil(
    caches.open(CACHE_NAME).then((cache) => cache.addAll(SHELL_ASSETS))
  );
  self.skipWaiting();
});

self.addEventListener('fetch', (event) => {
  if (event.request.method !== 'GET') {
    return;
  }

  const isApi = event.request.url.includes('/api/') || event.request.url.includes('/purchase');
  if (isApi) {
    event.respondWith(
      fetch(event.request)
        .then((response) => {
          if (response.ok) {
            cacheResponse(event.request, response.clone());
          }
          return response;
        })
        .catch(() => caches.match(event.request))
    );
    return;
  }

  event.respondWith(
    caches.match(event.request).then((cached) => cached || fetch(event.request).then((networkResponse) => {
      cacheResponse(event.request, networkResponse.clone());
      return networkResponse;
    }))
  );
});

function cacheResponse(request, response) {
  if (!response || response.status !== 200) return;
  caches.open(CACHE_NAME).then((cache) => cache.put(request, response));
}
